
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"
#include "newRandom.h"

static mb elem, elemDiff, elemMin;
static int n, *row, *col;

using namespace std;
static mb randTerm()
{
    mb  term;
    
    mbRandom(term, elemDiff);
    term = term + elemMin;
    return term;
    
}/* randTerm */

static void shuffle(int *z)
{
    int     i, r, temp;
    
    for(i=0;i<n;++i)
    {
        r = rand() % n;
        temp = z[i];
        z[i] = z[r];
        z[r] = temp;
    }
    
}/* shuffle */

static bool isNeg()
{
    int     z;
    
    z = rand() % 2;
    if(!z)
        return true;
    else
        return false;
    
}/* isNeg */

static void myCase0(matq& M)
{
    int     i, j, iMax, jMax;
    mb      termMax, f, offset;
    
    f = 100;
    termMax = 1;
    shuffle(row);
    iMax = rand() % n;
    for(i=0;i<iMax;++i)
    {
        shuffle(col);
        jMax = rand() % n;
        for(j=0;j<jMax;++j)
        {
            mbRandom(offset, termMax);
            offset = offset + 1;
            if(isNeg)
                offset = -offset;
            M.array[row[i]][col[j]] = M.array[row[i]][col[j]] + offset;
            M.array[col[j]][row[i]] = M.array[row[i]][col[j]];
        }
    }
    
}/* myCase0 */

static void myCase1(matq& M)
{
    int     i, j, iMax, jMax;
    mb      termMax, f, offset;
    
    f = 10000;
    termMax = 2;
    shuffle(row);
    iMax = rand() % n;
    for(i=0;i<iMax;++i)
    {
        shuffle(col);
        jMax = rand() % n;
        for(j=0;j<jMax;++j)
        {
            mbRandom(offset, termMax);
            offset = offset + 1;
            if(isNeg)
                offset = -offset;
            M.array[row[i]][col[j]] = M.array[row[i]][col[j]] + offset;
            M.array[col[j]][row[i]] = M.array[row[i]][col[j]];
        }
    }
    
}/* myCase1 */

static void myCase2(matq& M)
{
    int     i, j, iMax, jMax;
    mb      termMax, f, offset;
    
    //f = 100;
    termMax = 3;
    shuffle(row);
    iMax = rand() % n;
    for(i=0;i<iMax;++i)
    {
        shuffle(col);
        jMax = rand() % n;
        for(j=0;j<jMax;++j)
        {
            mbRandom(offset, termMax);
            offset = offset + 1;
            if(isNeg)
                offset = -offset;
            M.array[row[i]][col[j]] = M.array[row[i]][col[j]] + offset;
            M.array[col[j]][row[i]] = M.array[row[i]][col[j]];
        }
    }
    
}/* myCase2 */

int main (int argc, char * const argv[])
{
    matq        M, Mt;
    mb          N="111607"; // to be factored
    // = 233 * 479
    int         joltNum, maxJolts=300;
    int         caseNum, numCases=3, tries, triesMax=1000;
    bf          det;
    mb          diff, diffLast; // to go to zero
    mb          term, elemMax, one="1", f="11";
    int         i, j;
    
    n = 4;
    InitArray(0);
    srand (time(NULL));
    row = (int*)malloc(n*sizeof(int));
    col = (int*)malloc(n*sizeof(int));
    for(i=0;i<n;++i)
        row[i] = col[i] = i;
    
    elem = nthRoot(N, n); // 300 best?  11 digits
    //cout << elem << endl;
    //return 0;
    elemMin = elem - elem/f;
    elemMax = elem + elem/f;
    elemDiff = elemMax - elemMin;
    
    init(M, n, n);
    
    for(joltNum=0;joltNum<maxJolts;++joltNum)
    {
        cout << "jolt " << joltNum+1 << endl;
        for(i=0;i<M.nr;++i)
            for(j=i;j<M.nc;++j)
            {
                M.array[i][j] = randTerm();
                M.array[j][i] = M.array[i][j];
            }
        
            
        det = determinant(M);
        diffLast = abs(N - det.num);
        //cout << "diffLast = " << diffLast << endl;
        // gen random caseNum
        tries = 0;
        while(tries<triesMax)
        {
            Mt = M;
            caseNum = rand() % numCases;
            switch(caseNum)
            {
                case 0: myCase0(M);
                    break;
                case 1: myCase1(M);
                    break;
                case 2: myCase2(M);
                    break;
                default: ;
            }
            det = determinant(M);
            diff = abs(N - det.num);
            if(!diff)
            {
                cout << endl << "M = " << M << endl;
                return 0;
            }
            //cout << "diff = " << diff << endl;
            if(diff<diffLast)
            {
                diffLast = diff;
                tries = 0;
                //cout << diff << "            \r" << flush;
            }
            else
            {
                M = Mt;
                tries++;
            }
            if(tries==triesMax)
                cout << diffLast << endl;
        }
        
    }
    
    return 0;
}
// 233 * 479
// M = 7,14,-4,-9;4,-2,16,7;14,-13,-9,-9;-1,-5,-18,13
/*
 L =
 1 0 0 0
 4/7 1 0 0
 2 41/10 1 0
 -1/7 3/10 842/2659 1
 U =
 7 14 -4 -9
 0 -10 128/7 85/7
 0 0 -2659/35 -571/14
 0 0 0 111607/5318
 */
/*
 std::cout << "will not see this\rwill see this" << std::flush;
 std::cout << std::endl; // all done
 */
/*
 M = -39,-127,40;42,-17,-8;-11,47,11
 L =
 1 0 0
 -14/13 1 0
 11/39 -3230/5997 1
 U =
 -39 -127 40
 0 -1999/13 456/13
 0 0 111607/5997
 */
/*
 M = 2,1,9,1,5;0,-13,-11,-4,-2;-4,-2,-7,-15,-2;1,-5,1,-8,-11;4,6,-3,6,0
 L =
 1 0 0 0 0
 0 1 0 0 0
 -2 0 1 0 0
 2 -4/13 -317/143 1 0
 1/2 11/26 15/143 1557/7450
 U =
 2 1 9 1 5
 0 -13 -11 -4 -2
 0 0 11 -13 8
 0 0 0 -3725/143 1018/143
 0 0 0 0 -111607/7450
 */
/*
 M = 0,-1,0,-5,-3,0;-3,-3,-10,-10,-14,-6;-9,-5,-1,-11,-10,-9;-2,-2,0,-2,-4,-1;-7,-6,2,-8,-5,2;-6,-17,-8,-4,-6,-3
 L =
 1 0 0 0 0 0
 0 1 0 0 0 0
 1/3 4/3 1 0 0 0
 2/9 8/9 -2/87 1 0 0
 7/9 19/9 -25/87 325/142 1 0
 2/3 41/3 22/29 2071/142 766
 U =
 -9 -5 -1 -11 -10 -9
 0 -1 0 -5 -3 0
 0 0 -29/3 1/3 -20/3 -3
 0 0 0 142/29 64/87 27/29
 0 0 0 0 1174/213 853/142
 0 0 0 0 0 -111607/2348
 */
/*
 M = -1,-1,-2,4,-1,-1,0;0,-4,-3,-5,-2,2,0;-3,4,1,0,-2,4,3;-2,-5,1,-1,-1,1,-4;-6,-4,-4,-4,-3,-1,1;3,-1,-1,-6,1,-2,3;-6,-3,-2,-2,-9,-5,-1
 
 */
